<?php
require_once __DIR__ . '/conexion.php';

// Filtros (opcionales)
$search = isset($_GET['q']) ? trim($_GET['q']) : '';
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'nombre_asc';

$orderBy = "nombre ASC";
if ($sort === "precio_asc") $orderBy = "precio ASC";
if ($sort === "precio_desc") $orderBy = "precio DESC";
if ($sort === "nombre_desc") $orderBy = "nombre DESC";

$sql = "SELECT id, nombre, descripcion, precio, imagen FROM productos";
$params = [];
$types = "";

if ($search !== "") {
  $sql .= " WHERE nombre LIKE ? OR descripcion LIKE ?";
  $like = "%{$search}%";
  $params = [$like, $like];
  $types = "ss";
}

$sql .= " ORDER BY {$orderBy}";

$stmt = $conexion->prepare($sql);
if ($stmt === false) {
  http_response_code(500);
  die("Error preparando consulta.");
}

if (!empty($params)) {
  $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Productos · VerdeVida</title>
  <link rel="stylesheet" href="css/styles.css"/>
</head>
<body>
  <header class="header">
    <div class="container nav">
      <a class="brand" href="index.php">VerdeVida</a>
      <nav class="menu">
        <a class="active" href="productos.php">Productos</a>
        <a href="contacto.php">Contacto</a>
      </nav>
    </div>
  </header>

  <main class="container page">
    <div class="page-head">
      <div>
        <h1>Productos</h1>
        <p class="muted">Conectado a tu tabla <code>productos</code>.</p>
      </div>

      <form class="filters" method="GET" action="productos.php">
        <input class="input" type="text" name="q" placeholder="Buscar (maceta, semillas...)" value="<?php echo htmlspecialchars($search); ?>">
        <select class="select" name="sort">
          <option value="nombre_asc"  <?php echo ($sort==='nombre_asc')?'selected':''; ?>>Nombre (A–Z)</option>
          <option value="nombre_desc" <?php echo ($sort==='nombre_desc')?'selected':''; ?>>Nombre (Z–A)</option>
          <option value="precio_asc"  <?php echo ($sort==='precio_asc')?'selected':''; ?>>Precio (menor)</option>
          <option value="precio_desc" <?php echo ($sort==='precio_desc')?'selected':''; ?>>Precio (mayor)</option>
        </select>
        <button class="btn" type="submit">Aplicar</button>
      </form>
    </div>

    <section class="cards">
      <?php if ($result->num_rows === 0): ?>
        <div class="empty">
          <h3>No hay resultados</h3>
          <p class="muted">Probá otra búsqueda o revisá que la tabla tenga datos.</p>
        </div>
      <?php endif; ?>

      <?php while($p = $result->fetch_assoc()): ?>
        <a class="card" href="producto.php?id=<?php echo (int)$p['id']; ?>">
          <div class="thumb">
            <img src="images/<?php echo htmlspecialchars($p['imagen']); ?>" alt="<?php echo htmlspecialchars($p['nombre']); ?>" onerror="this.style.display='none'; this.parentElement.classList.add('thumb-fallback');">
            <div class="thumb-fallback-text">🌿</div>
          </div>
          <div class="card-body">
            <div class="card-top">
              <h3><?php echo htmlspecialchars($p['nombre']); ?></h3>
              <span class="price">₡<?php echo number_format((float)$p['precio'], 2); ?></span>
            </div>
            <p class="desc"><?php echo htmlspecialchars($p['descripcion']); ?></p>
            <span class="linkish">Ver detalle →</span>
          </div>
        </a>
      <?php endwhile; ?>
    </section>
  </main>

  <footer class="footer">
    <div class="container">
      <p>© <?php echo date('Y'); ?> VerdeVida Jardinería</p>
    </div>
  </footer>
</body>
</html>
<?php
$stmt->close();
$conexion->close();
?>