<?php
require_once __DIR__ . '/conexion.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  header("Location: productos.php");
  exit;
}

$stmt = $conexion->prepare("SELECT id, nombre, descripcion, precio, imagen FROM productos WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$p = $res->fetch_assoc();

if (!$p) {
  header("Location: productos.php");
  exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title><?php echo htmlspecialchars($p['nombre']); ?> · VerdeVida</title>
  <link rel="stylesheet" href="css/styles.css"/>
</head>
<body>
  <header class="header">
    <div class="container nav">
      <a class="brand" href="index.php">VerdeVida</a>
      <nav class="menu">
        <a class="active" href="productos.php">Productos</a>
        <a href="contacto.php">Contacto</a>
      </nav>
    </div>
  </header>

  <main class="container page">
    <a class="back" href="productos.php">← Volver</a>

    <section class="detail">
      <div class="detail-img">
        <img src="images/<?php echo htmlspecialchars($p['imagen']); ?>" alt="<?php echo htmlspecialchars($p['nombre']); ?>"
             onerror="this.style.display='none'; this.parentElement.classList.add('thumb-fallback');">
        <div class="thumb-fallback-text">🌿</div>
      </div>

      <div class="detail-info">
        <h1><?php echo htmlspecialchars($p['nombre']); ?></h1>
        <p class="price big">₡<?php echo number_format((float)$p['precio'], 2); ?></p>
        <p class="desc big"><?php echo htmlspecialchars($p['descripcion']); ?></p>

        <div class="cta-row">
          <a class="btn" href="contacto.php?producto=<?php echo urlencode($p['nombre']); ?>">Consultar</a>
          <span class="muted">Tip: en cPanel subí la imagen con el mismo nombre.</span>
        </div>
      </div>
    </section>
  </main>

  <footer class="footer">
    <div class="container">
      <p>© <?php echo date('Y'); ?> VerdeVida Jardinería</p>
    </div>
  </footer>
</body>
</html>
<?php
$stmt->close();
$conexion->close();
?>