<?php
$producto = isset($_GET['producto']) ? trim($_GET['producto']) : '';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Contacto · VerdeVida</title>
  <link rel="stylesheet" href="css/styles.css"/>
</head>
<body>
  <header class="header">
    <div class="container nav">
      <a class="brand" href="index.php">VerdeVida</a>
      <nav class="menu">
        <a href="productos.php">Productos</a>
        <a class="active" href="contacto.php">Contacto</a>
      </nav>
    </div>
  </header>

  <main class="container page">
    <div class="page-head">
      <div>
        <h1>Contacto</h1>
        <p class="muted">Formulario demo (podés conectarlo a correo después).</p>
      </div>
    </div>

    <form class="form" method="POST" action="#">
      <label>
        Nombre
        <input class="input" type="text" name="nombre" placeholder="Tu nombre" required>
      </label>

      <label>
        WhatsApp / Email
        <input class="input" type="text" name="contacto" placeholder="Ej: +506 8xxx-xxxx" required>
      </label>

      <label>
        Producto (opcional)
        <input class="input" type="text" name="producto" value="<?php echo htmlspecialchars($producto); ?>" placeholder="Ej: Maceta de barro">
      </label>

      <label>
        Mensaje
        <textarea class="textarea" name="mensaje" rows="5" placeholder="Contanos qué ocupás..." required></textarea>
      </label>

      <button class="btn" type="submit">Enviar</button>
      <p class="muted small">Luego lo conectamos a <code>mail()</code> o SMTP del hosting.</p>
    </form>
  </main>

  <footer class="footer">
    <div class="container">
      <p>© <?php echo date('Y'); ?> VerdeVida Jardinería</p>
    </div>
  </footer>
</body>
</html>
